package ru.yandex.wmconsole.servantlet.internal.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.wmconsole.service.UserOptionsService;

import java.util.List;

/**
 * @author avhaliullin
 */
public class ExportUsersNotificationOptionsAction extends Action<ExportUsersNotificationOptionsAction.Request, ExportUsersNotificationOptionsAction.Response> {
    private UserOptionsService userOptionsService;

    @Override
    public Response process(Request request) throws Exception {
        return new Response(userOptionsService.exportUserOptions(request.fromUserId, request.limit));
    }

    public static class Request implements ActionRequest {
        private long fromUserId;
        private int limit;

        @RequestQueryProperty(required = true)
        public void setFromUserId(long fromUserId) {
            this.fromUserId = fromUserId;
        }

        @RequestQueryProperty(required = true)
        public void setLimit(int limit) {
            this.limit = limit;
        }
    }

    public static class Response implements ActionResponse {
        private final List<UserOptionsService.ExportUserOptions> users;

        public Response(List<UserOptionsService.ExportUserOptions> users) {
            this.users = users;
        }

        public List<UserOptionsService.ExportUserOptions> getUsers() {
            return users;
        }
    }

    @Required
    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }
}
