package ru.yandex.wmconsole.servantlet.internal.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmconsole.util.BackportedIdUtils;
import ru.yandex.wmconsole.util.BackportedWebmasterHostId;

/**
 * @author avhaliullin
 */
public class GetNewWebmasterHostIdAction extends Action<GetNewWebmasterHostIdAction.Request, GetNewWebmasterHostIdAction.Response> {
    private HostInfoService hostInfoService;

    @Override
    public Response process(Request request) throws Exception {
        BriefHostInfo briefHostInfo = hostInfoService.getBriefHostInfoByIdOrName(String.valueOf(request.hostId));
        String hostIdString = null;
        if (briefHostInfo != null) {
            BackportedWebmasterHostId hostId = BackportedIdUtils.urlToHostId(briefHostInfo.getName());
            hostIdString = hostId.toStringId();
        }
        return new Response(hostIdString);
    }

    public static class Request implements ActionRequest {
        private long hostId;

        @RequestQueryProperty(required = true)
        public void setHostId(long hostId) {
            this.hostId = hostId;
        }
    }

    public static class Response implements ActionResponse {
        private final String hostId;

        public Response(String hostId) {
            this.hostId = hostId;
        }

        public String getHostId() {
            return hostId;
        }
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }
}
