package ru.yandex.wmconsole.servantlet.internal.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmconsole.util.BackportedIdUtils;
import ru.yandex.wmconsole.util.BackportedWebmasterHostId;

/**
 * @author avhaliullin
 */
public class GetOldWebmasterHostIdAction extends Action<GetOldWebmasterHostIdAction.Request, GetOldWebmasterHostIdAction.Response> {
    private HostInfoService hostInfoService;

    @Override
    public Response process(Request request) throws Exception {
        BackportedWebmasterHostId hostId = BackportedIdUtils.stringToHostId(request.hostId);

        BriefHostInfo briefHostInfo = hostInfoService.getBriefHostInfoByIdOrName(BackportedIdUtils.toRobotHostString(hostId));
        if (briefHostInfo != null) {
            return new Response(briefHostInfo.getId());
        }
        return new Response(null);
    }

    public static class Request implements ActionRequest {
        private String hostId;

        @RequestQueryProperty(required = true)
        public void setHostId(String hostId) {
            this.hostId = hostId;
        }
    }

    public static class Response implements ActionResponse {
        private final Long hostId;

        public Response(Long hostId) {
            this.hostId = hostId;
        }

        public Long getHostId() {
            return hostId;
        }
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }
}
