package ru.yandex.wmconsole.servantlet.internal.api;

/**
 * User: azakharov
 * Date: 18.04.14
 * Time: 13:50
 */

import java.net.IDN;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.WebmasterException;
import ru.yandex.webmaster.common.WebmasterExceptionType;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.request.HostIdAware;
import ru.yandex.webmaster.common.http.request.UserIdAware;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.service.UsersHostsService;

/**
 * User: azakharov
 * Date: 16.04.14
 * Time: 13:56
 */
public class HostNameByHostIdAction extends
        Action<HostNameByHostIdAction.HostNameByHostIdRequest, HostNameByHostIdAction.HostNameByHostIdResponse>
{

    private UsersHostsService usersHostsService;

    @Override
    public HostNameByHostIdResponse process(final HostNameByHostIdRequest request) throws Exception {
        final UsersHostsInfo usersHostsInfo = usersHostsService.getUsersHostsInfo(request.getUserId(), request.getHostId());
        if (usersHostsInfo == null) {
            throw new WebmasterException(WebmasterExceptionType.USER__HOST_NOT_OWNED, "Host is now owned by user");
        }
        final String unicodeName = IDN.toUnicode(usersHostsInfo.getHostName());
        final boolean isVerified = usersHostsInfo.getVerificationState() != null && usersHostsInfo.getVerificationState().isVerified();
        return new HostNameByHostIdResponse(usersHostsInfo.getHostName(), unicodeName, isVerified);
    }

    public static class HostNameByHostIdRequest implements InternalApiRequest, HostIdAware, UserIdAware {
        private long userId;
        private long hostId;
        private String source;

        @Override
        public void setHostId(long hostId) {
            this.hostId = hostId;
        }

        @Override
        public long getHostId() {
            return hostId;
        }

        @Override
        public long getUserId() {
            return userId;
        }

        @Override
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @Override
        public String getSource() {
            return source;
        }

        @Override
        public void setSource(String source) {
            this.source = source;
        }
    }

    public static class HostNameByHostIdResponse implements ActionResponse {
        private final String name;
        private final String punycodeName;
        private final boolean isVerified;

        public HostNameByHostIdResponse(final String name, final String punycodeName, final boolean isVerified) {
            this.name = name;
            this.punycodeName = punycodeName;
            this.isVerified = isVerified;
        }

        public String getName() {
            return name;
        }

        public String getPunycodeName() {
            return punycodeName;
        }

        public boolean isVerified() {
            return isVerified;
        }
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }
}
