package ru.yandex.wmconsole.servantlet.internal.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.request.UserIdAware;
import ru.yandex.wmconsole.data.info.OwnedHostInfo;
import ru.yandex.wmconsole.service.UsersHostsService;

import java.util.ArrayList;
import java.util.List;

/**
 * User: azakharov
 * Date: 16.04.14
 * Time: 12:56
 */
public class HostsAddedByUserAction extends Action<HostsAddedByUserAction.HostsAddedByUserRequest, HostsAddedByUserAction.HostsAddedByUserResponse> {

    private UsersHostsService usersHostsService;

    @Override
    public HostsAddedByUserResponse process(HostsAddedByUserRequest request) throws Exception {

        List<OwnedHostInfo> usersHostsInfo = usersHostsService.getUserHosts(request.getUserId(), true);

        List<Host> hosts = new ArrayList<>(usersHostsInfo.size());
        for (OwnedHostInfo info : usersHostsInfo) {
            boolean verified = info.getVerificationState() != null && info.getVerificationState().isVerified();
            boolean mainMirror = info.getMainMirrorId() == null;
            hosts.add(new Host(info.getId(), info.getName(), info.getPunycodeName(), verified, mainMirror));
        }
        return new HostsAddedByUserResponse(hosts);
    }

    public static class HostsAddedByUserRequest implements InternalApiRequest, UserIdAware {
        private long userId;
        private String source;

        @Override
        public long getUserId() {
            return userId;
        }

        @Override
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @Override
        public void setSource(String source) {
            this.source = source;
        }

        @Override
        public String getSource() {
            return source;
        }
    }

    public static class HostsAddedByUserResponse implements ActionResponse {
        private List<Host> hosts;

        public HostsAddedByUserResponse(List<Host> hosts) {
            this.hosts = hosts;
        }

        public List<Host> getHosts() {
            return hosts;
        }
    }

    public static class Host {
        private long id;
        private String name;
        private String punycodeName;
        private boolean verified;
        private boolean isMainMirror;

        public Host(long id, String name, String punycodeName, boolean verified, boolean isMainMirror) {
            this.id = id;
            this.name = name;
            this.punycodeName = punycodeName;
            this.verified = verified;
            this.isMainMirror = isMainMirror;
        }

        public long getId() {
            return id;
        }

        public String getName() {
            return name;
        }

        public String getPunycodeName() {
            return punycodeName;
        }

        public boolean isVerified() {
            return verified;
        }

        public boolean isMainMirror() {
            return isMainMirror;
        }
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }
}
