package ru.yandex.wmconsole.servantlet.internal.api;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.wmconsole.service.UserOptionsService;

/**
 * @author avhaliullin
 */
public class UpdateUserNotificationsEmailAction extends Action<UpdateUserNotificationsEmailAction.Request, UpdateUserNotificationsEmailAction.Response> {
    private UserOptionsService userOptionsService;

    @Override
    public Response process(Request request) throws Exception {
        String email = request.email == null ? "" : request.email;
        userOptionsService.updateUserEmail(request.userId, email);
        return new Response();
    }

    public static class Request implements ActionRequest {
        private long userId;
        private String email;

        @RequestQueryProperty(required = true)
        public void setUserId(long userId) {
            this.userId = userId;
        }

        @RequestQueryProperty(required = false)
        public void setEmail(String email) {
            this.email = email;
        }
    }

    public static class Response implements ActionResponse {

    }

    @Required
    public void setUserOptionsService(UserOptionsService userOptionsService) {
        this.userOptionsService = userOptionsService;
    }
}
