package ru.yandex.wmconsole.servantlet.internal.api.verification;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.util.collections.Pair;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.webmaster.common.newwmc.VerificationView;
import ru.yandex.wmconsole.data.info.UsersHostsInfo;
import ru.yandex.wmconsole.service.UsersHostsService;

import java.util.ArrayList;
import java.util.List;

/**
 * @author avhaliullin
 */
public class ExportVerificationsAction extends Action<ExportVerificationsAction.Request, ExportVerificationsAction.Response> {
    private UsersHostsService usersHostsService;

    @Override
    public Response process(Request request) throws Exception {
        List<Pair<UsersHostsInfo, Long>> usersHostsInfos = usersHostsService.listAllVerifications(request.page, request.pageSize);
        List<VerificationView> verificationViews = new ArrayList<>();
        for (Pair<UsersHostsInfo, Long> pair : usersHostsInfos) {
            UsersHostsInfo usersHostsInfo = pair.first;

            verificationViews.add(new VerificationView(
                    pair.second, usersHostsInfo.getUserId(),
                    usersHostsInfo.getHostName(),
                    usersHostsInfo.getVerificationType(),
                    usersHostsInfo.getVerificationState(),
                    usersHostsInfo.getVerificationDate() == null ? null : usersHostsInfo.getVerificationDate().getTime(),
                    usersHostsInfo.getVerificationUin()
            ));
        }
        return new Response(verificationViews);
    }

    public static class Request implements ActionRequest {
        private int page;
        private int pageSize;

        @RequestQueryProperty(required = true)
        public void setPage(int page) {
            this.page = page;
        }

        @RequestQueryProperty(required = true)
        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class Response implements ActionResponse {
        private final List<VerificationView> verifications;

        public Response(List<VerificationView> verifications) {
            this.verifications = verifications;
        }

        public List<VerificationView> getVerifications() {
            return verifications;
        }
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }
}
