package ru.yandex.wmconsole.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;

import ru.yandex.wmconsole.data.VirusNotificationInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 * @deprecated Не используется, так как совпадает с healed
 */
@Deprecated
public class CheckCuredService extends AbstractDbService implements GroupableByHostService<VirusNotificationInfo> {
    private static final String INSERT_CURED_NOTIFICATION_QUERY =
            "INSERT INTO " +
                        "tbl_notification_checkcured (host_id, receive_time) " +
                    "VALUES (?, ?)";

    private static final String SELECT_CURED_QUERY =
            "SELECT " +
                        "host_id, receive_time " +
                    "FROM " +
                        "tbl_notification_checkcured " +
                    "WHERE " +
                        "checkcured_id = ?";

    private static final ParameterizedRowMapper<VirusNotificationInfo> VIRUS_NOTIFICATION_MAPPER =
            new ParameterizedRowMapper<VirusNotificationInfo>() {
                private static final String FIELD_HOST_ID = "host_id";
                private static final String FIELD_RECEIVE_TIME = "receive_time";

                @Override
                public VirusNotificationInfo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
                    Long hostId = resultSet.getLong(FIELD_HOST_ID);
                    Date receiveTime = resultSet.getDate(FIELD_RECEIVE_TIME);
                    return new VirusNotificationInfo(hostId, receiveTime);
                }
            };

    public Long addCheckCuredNotification(final Long hostId, final java.util.Date date) throws InternalException {
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        PreparedStatementCreator psc = new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(INSERT_CURED_NOTIFICATION_QUERY,
                        Statement.RETURN_GENERATED_KEYS);
                ps.setLong(1, hostId);
                ps.setTimestamp(2, new Timestamp(date.getTime()));
                return ps;
            }
        };

        getJdbcTemplate(WMCPartition.nullPartition()).getJdbcOperations().update(psc, generatedKeyHolder);
        return generatedKeyHolder.getKey().longValue();
    }

    public VirusNotificationInfo getCheckCuredNotification(Long checkCuredNotificationId) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).queryForObject(
                SELECT_CURED_QUERY,
                VIRUS_NOTIFICATION_MAPPER,
                checkCuredNotificationId
        );
    }

    @Override
    public VirusNotificationInfo getSingleNotification(Long id) throws InternalException {
        return getCheckCuredNotification(id);
    }
}
