package ru.yandex.wmconsole.service;

import java.util.Date;

import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class CollectConcurrencyService extends AbstractDbService {
    private static final String REPLACE_DATE_FOR_TYPE_QUERY =
            "REPLACE INTO " +
                        "tbl_notification_concurrency (type, last_update) " +
                    "VALUES (?, NOW())";

    private static final String SELECT_DATE_FOR_UPDATE_QUERY =
            "SELECT " +
                        "last_update " +
                    "FROM " +
                        "tbl_notification_concurrency " +
                    "WHERE " +
                        "type = ?";

    public void updateType(NotificationTypeEnum type) throws InternalException {
        getJdbcTemplate(WMCPartition.nullPartition()).update(
                REPLACE_DATE_FOR_TYPE_QUERY,
                type.getValue()
        );
    }

    public Date getTypeUpdateDate(NotificationTypeEnum type) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).queryForObject(
                SELECT_DATE_FOR_UPDATE_QUERY,
                Date.class,
                type.getValue()
        );
    }
}
