package ru.yandex.wmconsole.service;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;

import ru.yandex.wmconsole.data.GlobalMessageNotificationInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class GlobalMessageService extends AbstractDbService {
    private static final String INSERT_GLOBAL_MESSAGE_QUERY =
            "INSERT INTO " +
                        "tbl_notification_globalmessages (message, header, receive_time) " +
                    "VALUES (?, ?, ?)";

    private static final String SELECT_GLOBAL_MESSAGE_QUERY =
            "SELECT " +
                        "message, header, receive_time " +
                    "FROM " +
                        "tbl_notification_globalmessages " +
                    "WHERE " +
                        "message_id = ?";

    private static final ParameterizedRowMapper<GlobalMessageNotificationInfo> MESSAGE_MAPPER =
            new ParameterizedRowMapper<GlobalMessageNotificationInfo>() {
                private static final String FIELD_MESSAGE = "message";
                private static final String FIELD_HEADER = "header";
                private static final String FIELD_RECEIVE_TIME = "receive_time";

                @Override
                public GlobalMessageNotificationInfo mapRow(ResultSet resultSet, int rowNum) throws SQLException {
                    String message = resultSet.getString(FIELD_MESSAGE);
                    String header = resultSet.getString(FIELD_HEADER);
                    Date receiveTime = resultSet.getDate(FIELD_RECEIVE_TIME);
                    return new GlobalMessageNotificationInfo(message, header, receiveTime);
                }
            };

    public Long addGlobalMessage(final String message, final String header, final Date date) throws InternalException {
        GeneratedKeyHolder generatedKeyHolder = new GeneratedKeyHolder();
        PreparedStatementCreator psc = new PreparedStatementCreator() {
            @Override
            public PreparedStatement createPreparedStatement(Connection connection) throws SQLException {
                PreparedStatement ps = connection.prepareStatement(INSERT_GLOBAL_MESSAGE_QUERY,
                        Statement.RETURN_GENERATED_KEYS);
                ps.setString(1, message);
                ps.setString(2, header);
                ps.setTimestamp(3, new Timestamp(date.getTime()));
                return ps;
            }
        };

        getJdbcTemplate(WMCPartition.nullPartition()).getJdbcOperations().update(psc, generatedKeyHolder);
        return generatedKeyHolder.getKey().longValue();
    }

    public GlobalMessageNotificationInfo getGlobalMessage(Long messageId) throws InternalException {
        return getJdbcTemplate(WMCPartition.nullPartition()).queryForObject(
                SELECT_GLOBAL_MESSAGE_QUERY,
                MESSAGE_MAPPER,
                messageId
        );
    }
}
