package ru.yandex.webmaster.periodic.host;

import ru.yandex.misc.enums.IntEnum;
import ru.yandex.misc.enums.IntEnumResolver;

/**
 * @author aherman
 */
public enum HostEventTaskType implements IntEnum {
    UNKNOWN(0),

    NEW_HOST_ADD_URL(1),
    VERIFIED_HOST_ADD_URL(2),
    W3_HOST_LIST_SYNC(3)
    ;

    private final int value;

    private HostEventTaskType(int value) {
        this.value = value;
    }

    @Override
    public int value() {
        return value;
    }

    public static final IntEnumResolver<HostEventTaskType> R = IntEnumResolver.r(HostEventTaskType.class);
}
