package ru.yandex.webmaster.periodic.host.dao;

import org.joda.time.DateTime;

import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.webmaster.periodic.host.HostEventTaskType;
import ru.yandex.webmaster.periodic.host.LastEventState;

import static ru.yandex.webmaster.periodic.host.dao.TblHostEventTaskStateDao.COLUMN_DATE;
import static ru.yandex.webmaster.periodic.host.dao.TblHostEventTaskStateDao.COLUMN_RETRY_COUNT;
import static ru.yandex.webmaster.periodic.host.dao.TblHostEventTaskStateDao.COLUMN_STATE;
import static ru.yandex.webmaster.periodic.host.dao.TblHostEventTaskStateDao.COLUMN_TASK_ID;

/**
 * @author aherman
 */
public class TblHostEventTaskStateCondition {
    public static SqlCondition task(HostEventTaskType hostEventTaskType) {
        return SqlCondition.column(COLUMN_TASK_ID).eq(hostEventTaskType.value());
    }

    public static SqlCondition state(LastEventState state) {
        return SqlCondition.column(COLUMN_STATE).eq(state.value());
    }

    public static SqlCondition dateOlderThan(DateTime dateTime) {
        return SqlCondition.column(COLUMN_DATE).le(dateTime.toDate());
    }

    public static SqlCondition retryCountGreaterThan(int minRetryCount) {
        return SqlCondition.column(COLUMN_RETRY_COUNT).gt(minRetryCount);
    }
}
