package ru.yandex.webmaster.periodic.seolinks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.common.util.db.StringRowMapper;
import ru.yandex.webmaster.common.seolinks.SeoLinksSettingsService;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.service.UsersHostsService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

import java.util.List;

/**
 * User: azakharov
 * Date: 30.05.14
 * Time: 19:47
 */
public class ExportSeoLinksSettingsTask extends AbstractTaskExecutor {

    private static final Logger log = LoggerFactory.getLogger(ExportSeoLinksSettingsTask.class);

    private UsersHostsService usersHostsService;
    private SeoLinksSettingsService seoLinksSettingsService;

    @Override
    public String runWithRELogging(ExecutionContext context) throws InternalException {
        log.info("Refreshing hostnames in tbl_seo_links");
        for (int module = 0; module < 256; module++) {
            // get hosts from mysql
            List<String> results = usersHostsService.getHostsAddedByUsers(256, module);
            // save them to cassandra
            seoLinksSettingsService.refreshHosts(results.iterator());
        }

        log.info("Exporting seo links settings to file");
        return seoLinksSettingsService.exportSettings();
    }

    @Required
    public void setSeoLinksSettingsService(SeoLinksSettingsService seoLinksSettingsService) {
        this.seoLinksSettingsService = seoLinksSettingsService;
    }

    @Required
    public void setUsersHostsService(UsersHostsService usersHostsService) {
        this.usersHostsService = usersHostsService;
    }
}
