package ru.yandex.wmconsole.notifier.provider;

import org.jdom.Element;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.wmconsole.data.ClearBadSoftwareNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.ClearBadSoftwareNotificationService;
import ru.yandex.wmtools.common.error.InternalException;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * User: azakharov
 * Date: 08.08.14
 * Time: 16:49
 */
public class ClearBadSoftwareProvider extends AbstractHostInfoProvider {

    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private ClearBadSoftwareNotificationService clearBadSoftwareNotificationService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel) throws InternalException {
        ClearBadSoftwareNotificationInfo info =
                clearBadSoftwareNotificationService.getSingleNotificationInfo(notification.getIssueId());
        Date d = info.getReceiveTime();
        String date = DATE_FORMAT.format(d);
        Element dateElement = new Element("receive-time");
        dateElement.setText(date);
        Element hostElement = getHostElement(info.getHostId());
        hostElement.addContent(dateElement);
        return Cf.list(hostElement);
    }

    @Required
    public void setClearBadSoftwareNotificationService(ClearBadSoftwareNotificationService clearBadSoftwareNotificationService) {
        this.clearBadSoftwareNotificationService = clearBadSoftwareNotificationService;
    }
}
