package ru.yandex.wmconsole.notifier.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.CloakingNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.CloakingNotificationService;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class CloakingProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(XssProvider.class);

    private CloakingNotificationService cloakingService;
//    private ByHostIdStrategy<CloakingNotificationInfo> cloakingStrategy;
    private HostInfoService hostInfoService;

    private static final String TAG_URL = "url";
    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_HOST_NAME = "name";

//    @Override
//    public SendStrategy getSendStrategy() {
//        return cloakingStrategy;
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            CloakingNotificationInfo cloakingNotificationInfo =
                    cloakingService.getCloakingNotification(notification.getIssueId());
            elements.add(getHostElement(cloakingNotificationInfo));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting cloaking message");
            throw e;
        }
        return elements;
    }

    private Element getUrlElement(CloakingNotificationInfo cloakingNotificationInfo) {
        Element element = new Element(TAG_URL);
        try {
            URL url = SupportedProtocols.getURL(cloakingNotificationInfo.getUrl());
            element.setText(url.toString());
        } catch (Exception e) {
            // ignore strange urls
            element.setText(cloakingNotificationInfo.getUrl());
        }
        return element;
    }

    private Element getHostElement(CloakingNotificationInfo cloakingNotificationInfo) throws InternalException {
        Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_ID, cloakingNotificationInfo.getHostId().toString());
        String hostName = hostInfoService.getHostNameByHostId(cloakingNotificationInfo.getHostId());
        element.setAttribute(ATTRIBUTE_HOST_NAME, hostName);
        element.addContent(getUrlElement(cloakingNotificationInfo));
        return element;
    }

    @Required
    public void setCloakingService(CloakingNotificationService cloakingService) {
        this.cloakingService = cloakingService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }

//    @Required
//    public void setCloakingStrategy(ByHostIdStrategy<CloakingNotificationInfo> cloakingStrategy) {
//        this.cloakingStrategy = cloakingStrategy;
//    }
}
