package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.DelegationNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.DelegationNotificationService;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author avhaliullin
 */
public class DelegationProvider extends AbstractHostInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DelegationProvider.class);

    private static final String TAG_USER = "user";
    private static final String TAG_DElEGATION_DATE = "delegation-date";
    private static final String TAG_ROOT = "delegated";
    private static final String ATTRIBUTE_MAY_REDELEGATE = "may-redelegate";
    private static final String ATTRIBUTE_GIVING_DELEGATION = "giving-delegation";

    private DelegationNotificationService delegationNotificationService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel) throws InternalException {
        log.debug("Delegation notification");
        List<Element> elements = new ArrayList<Element>();
        Element root = new Element(TAG_ROOT);
        elements.add(root);

        DelegationNotificationInfo info = delegationNotificationService.getDelegationNotificationInfo(notification.getIssueId());
        if (info == null) {
            return null;
        }

        root.addContent(getHostElement(info.getHostId()));

        StringBuilder date = new StringBuilder();
        new DateWrapper(info.getDelegationDate()).toXml(date);
        try {
            root.addContent(xmlToElement(date.toString(), TAG_DElEGATION_DATE));
        } catch (JDOMException e) {
            log.error("Failed to parse DateWrapper's result:", e);
            return null;
        }

        StringBuilder userInfo = new StringBuilder();
        new BlackBoxUserInfoWrapper(info.getUserGaveInfo()).toXml(userInfo);
        try {
            root.addContent(xmlToElement(userInfo.toString(), TAG_USER));
        } catch (JDOMException e) {
            log.error("Failed to parse user info:", e);
            return null;
        }

        root.setAttribute(ATTRIBUTE_MAY_REDELEGATE, info.isMayRedelegate() ? "true" : "false");
        root.setAttribute(ATTRIBUTE_GIVING_DELEGATION, info.isGivingDelegation() ? "true" : "false");

        return elements;
    }

    @Required
    public void setDelegationNotificationService(DelegationNotificationService delegationNotificationService) {
        this.delegationNotificationService = delegationNotificationService;
    }
}
