package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.DoorwayNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.DoorwayNotificationService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * User: Alexey Zakharov <azakharov@yandex-team.ru>
 * Date: 20.02.12
 */
public class DoorwayProvider extends AbstractHostInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(DoorwayProvider.class);

    private DoorwayNotificationService doorwayNotificationService;

    private static final String TAG_URL = "url";

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        final List<Element> elements = new ArrayList<Element>();
        try {
            final DoorwayNotificationInfo doorwayNotificationInfo =
                    doorwayNotificationService.getDoorwayNotification(notification.getIssueId());

            final Element element = getHostElement(doorwayNotificationInfo.getHostId());

            element.addContent(getUrlElement(doorwayNotificationInfo));
            elements.add(element);
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting xss message");
            throw e;
        }
        return elements;
    }

    private Element getUrlElement(final DoorwayNotificationInfo doorwayNotificationInfo) {
        final Element element = new Element(TAG_URL);
        element.setText(doorwayNotificationInfo.getUrl());
        return element;
    }

    @Required
    public void setDoorwayNotificationService(DoorwayNotificationService doorwayNotificationService) {
        this.doorwayNotificationService = doorwayNotificationService;
    }
}
