package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.ErrorsGrowNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.ErrorsGrowService;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class ErrorsGrowProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(ErrorsGrowProvider.class);

    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_ID = "id";
    private static final String TAG_PERCENT = "percent";

    private ErrorsGrowService errorsGrowService;
    private HostInfoService hostInfoService;

//    @Override
//    public SendStrategy getSendStrategy() {
//        return DefaultSendStrategy.getInstance();
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            ErrorsGrowNotificationInfo errorsGrowNotification = getErrorsGrowNotification(notification);
            elements.add(getPercentElement(errorsGrowNotification));
            elements.add(getHostElement(errorsGrowNotification));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting errors grow");
            throw e;
        }
        return elements;
    }

    private ErrorsGrowNotificationInfo getErrorsGrowNotification(NotificationInfo notification)
            throws InternalException {
        return errorsGrowService.getErrorsGrowNotification(notification.getIssueId());
    }

    private Element getHostElement(ErrorsGrowNotificationInfo errorsGrowNotification) throws InternalException {
        Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_ID, errorsGrowNotification.getHostId().toString());
        String hostName = hostInfoService.getHostNameByHostId(errorsGrowNotification.getHostId());
        element.setText(hostName);
        return element;
    }

    private Element getPercentElement(ErrorsGrowNotificationInfo errorsGrowNotification) {
        Element element = new Element(TAG_PERCENT);
        element.setText(errorsGrowNotification.getPercent().toString());
        return element;
    }

    @Required
    public void setErrorsGrowService(ErrorsGrowService errorsGrowService) {
        this.errorsGrowService = errorsGrowService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }
}
