package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.VirusNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.HealedNotificationService;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class HealedProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(HealedProvider.class);

    private HealedNotificationService healedNotificationService;
//    private ByHostIdStrategy<VirusNotificationInfo> healedStrategy;
    private HostInfoService hostInfoService;

    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_HOST_NAME = "name";

//    @Override
//    public SendStrategy getSendStrategy() {
//        return healedStrategy;
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            VirusNotificationInfo virusNotificationInfo =
                    healedNotificationService.getHealedNotification(notification.getIssueId());
            elements.add(getHostElement(virusNotificationInfo));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting healed message");
            throw e;
        }
        return elements;
    }

    private Element getHostElement(VirusNotificationInfo virusNotificationInfo) throws InternalException {
        Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_ID, virusNotificationInfo.getHostId().toString());
        String hostName = hostInfoService.getHostNameByHostId(virusNotificationInfo.getHostId());
        element.setAttribute(ATTRIBUTE_HOST_NAME, hostName);
        return element;
    }

    @Required
    public void setHealedNotificationService(HealedNotificationService healedNotificationService) {
        this.healedNotificationService = healedNotificationService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }

//    @Required
//    public void setHealedStrategy(ByHostIdStrategy<VirusNotificationInfo> healedStrategy) {
//        this.healedStrategy = healedStrategy;
//    }
}
