package ru.yandex.wmconsole.notifier.provider;

import java.net.IDN;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.HostStatusChangedNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.GroupableByHostService;
import ru.yandex.wmconsole.service.HostStatusChangedService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.XmlDataWrapper;

/**
 * @author Alexey Zakharov <azakharov@yandex-team.ru>
 */
public class HostStatusChangedProvider extends AbstractHostInfoProvider implements GroupableByHostService<HostStatusChangedNotificationInfo>{
    private static final Logger log = LoggerFactory.getLogger(HostStatusChangedProvider.class);

    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_HOST_ID = "id";
    private static final String ATTRIBUTE_HOST_NAME = "name";
    private static final String ATTRIBUTE_STATUS = "status";
    private static final String ATTRIBUTE_SPIDER_IP = "spider";
    private static final String ATTRIBUTE_LAST_ACCESS = "last-access";

    private HostStatusChangedService hostStatusChangedService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            HostStatusChangedNotificationInfo notificationInfo =
                    hostStatusChangedService.getHostStatusChanged(notification.getIssueId());
            elements.add(getHostElement(notificationInfo));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting virus message");
            throw e;
        }
        return elements;
    }

    private Element getHostElement(final HostStatusChangedNotificationInfo notificationInfo) throws InternalException {
        final Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_HOST_ID, String.valueOf(notificationInfo.getHostId()));
        final String hostName = hostInfoService.getHostNameByHostId(notificationInfo.getHostId());
        final String punicodeName = IDN.toUnicode(hostName);
        element.setAttribute(ATTRIBUTE_HOST_NAME, punicodeName);
        element.setAttribute(ATTRIBUTE_STATUS, String.valueOf(notificationInfo.getStatus()));
        element.setAttribute(ATTRIBUTE_SPIDER_IP, notificationInfo.getSpiderIp());
        if (notificationInfo.getLastAccess() != null) {
            element.setAttribute(ATTRIBUTE_LAST_ACCESS,
                    XmlDataWrapper.getDateFormat().format(notificationInfo.getLastAccess()));
        } else {
            element.setAttribute(ATTRIBUTE_LAST_ACCESS, "");
        }
        return element;
    }

    @Override
    public HostStatusChangedNotificationInfo getSingleNotification(Long id) throws InternalException {
        return hostStatusChangedService.getHostStatusChanged(id);
    }

    @Required
    public void setHostStatusChangedService(HostStatusChangedService hostStatusChangedService) {
        this.hostStatusChangedService = hostStatusChangedService;
    }
}
