package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;

import ru.yandex.wmconsole.data.info.notification.MainMirrorNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.dao.TblNotificationMirrorChangedDao;
import ru.yandex.wmtools.common.error.InternalException;

public class MirrorChangedProvider  implements Provider {

    private static final String TAG_OLD_HOST = "old-host";
    private static final String TAG_NEW_HOST = "new-host";

    private TblNotificationMirrorChangedDao tblNotificationMirrorChangedDao;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        MainMirrorNotificationInfo info = tblNotificationMirrorChangedDao.getMainMirrorChangeNotification(notification.getIssueId());

        return getNotificationElement(info);
    }

    protected List<Element> getNotificationElement(MainMirrorNotificationInfo info) {
        Element oldHostElement = new Element(TAG_OLD_HOST);
        oldHostElement.setText(info.getOldHost());

        Element newHostElement = new Element(TAG_NEW_HOST);
        newHostElement.setText(info.getNewHost());

        List<Element> elements = new ArrayList<Element>();
        elements.add(oldHostElement);
        elements.add(newHostElement);
        return elements;
    }

    public void setTblNotificationMirrorChangedDao(TblNotificationMirrorChangedDao tblNotificationMirrorChangedDao) {
        this.tblNotificationMirrorChangedDao = tblNotificationMirrorChangedDao;
    }
}
