package ru.yandex.wmconsole.notifier.provider;

import org.jdom.Element;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.util.collections.Cf;
import ru.yandex.wmconsole.data.BadSoftwareNotificationInfo;
import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.BadSoftwareNotificationService;
import ru.yandex.wmtools.common.error.InternalException;

import java.util.List;

/**
 * User: azakharov
 * Date: 08.08.14
 * Time: 16:41
 */
public class NewBadSoftwareProvider extends AbstractHostInfoProvider {

    private BadSoftwareNotificationService badSoftwareNotificationService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel) throws InternalException {
        BadSoftwareNotificationInfo info = badSoftwareNotificationService.getSingleNotification(notification.getIssueId());
        Element element = getHostElement(info.getHostId());
        Element urlElement = new Element("url");
        urlElement.setText(info.getUrl());
        element.addContent(urlElement);
        return Cf.list(element);
    }

    @Required
    public void setBadSoftwareNotificationService(BadSoftwareNotificationService badSoftwareNotificationService) {
        this.badSoftwareNotificationService = badSoftwareNotificationService;
    }
}
