package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.PersonalMessageNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.PersonalMessageService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class PersonalMessageProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(PersonalMessageProvider.class);

    private PersonalMessageService personalMessageService;

    private static final String TAG_MESSAGE = "message";
    private static final String TAG_TITLE = "title";

//    @Override
//    public SendStrategy getSendStrategy() {
//        return DefaultSendStrategy.getInstance();
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            PersonalMessageNotificationInfo personalMessage =
                    personalMessageService.getPersonalMessage(notification.getIssueId());
            elements.add(getMessageElement(personalMessage, channel));
            elements.add(getTitleElement(personalMessage));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting global message");
            throw e;
        }
        return elements;
    }

    private Element getMessageElement(PersonalMessageNotificationInfo personalMessage, NotificationChannelEnum channel) {
        Element element = new Element(TAG_MESSAGE);
        String message = personalMessage.getMessage();
        element.setText(message);
        return element;
    }

    private Element getTitleElement(PersonalMessageNotificationInfo personalMessage) {
        Element element = new Element(TAG_TITLE);
        element.setText(personalMessage.getHeader());
        return element;
    }

    @Required
    public void setPersonalMessageService(PersonalMessageService personalMessageService) {
        this.personalMessageService = personalMessageService;
    }
}
