package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.SearchUpdateService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class SearchUpdateProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(SearchUpdateProvider.class);

    private SearchUpdateService searchUpdateService;

    private static final String TAG_RECEIVE_TIME = "receive-time";

//    @Override
//    public SendStrategy getSendStrategy() {
//        return DefaultSendStrategy.getInstance();
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            elements.add(getMessageElement(notification));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting search update message");
            throw e;
        }
        return elements;
    }

    private Element getMessageElement(NotificationInfo notification) throws InternalException {
        Element element = new Element(TAG_RECEIVE_TIME);
        element.setText(searchUpdateService.getSearchUpdateReceiveTime(notification.getIssueId()).toString());
        return element;
    }

    @Required
    public void setSearchUpdateService(SearchUpdateService searchUpdateService) {
        this.searchUpdateService = searchUpdateService;
    }
}
