package ru.yandex.wmconsole.notifier.provider;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.SpamNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmconsole.service.SpamNotificationService;
import ru.yandex.wmtools.common.SupportedProtocols;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class SpamProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(SpamProvider.class);

    private SpamNotificationService spamNotificationService;
//    private ByHostIdStrategy<SpamNotificationInfo> spamStrategy;
    private HostInfoService hostInfoService;

    private static final String TAG_URL = "url";
    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_HOST_NAME = "name";

//    @Override
//    public SendStrategy getSendStrategy() {
//        return spamStrategy;
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            SpamNotificationInfo spamNotificationInfo =
                    spamNotificationService.getSpamNotification(notification.getIssueId());
            elements.add(getHostElement(spamNotificationInfo));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting spam message");
            throw e;
        }
        return elements;
    }

    private Element getUrlElement(SpamNotificationInfo spamNotificationInfo) {
        Element element = new Element(TAG_URL);
        try {
            URL url = SupportedProtocols.getURL(spamNotificationInfo.getUrl());
            element.setText(url.toString());
        } catch (Exception e) {
            // ignore strange urls
            element.setText(spamNotificationInfo.getUrl());
        }
        return element;
    }

    private Element getHostElement(SpamNotificationInfo spamNotificationInfo) throws InternalException {
        Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_ID, spamNotificationInfo.getHostId().toString());
        String hostName = hostInfoService.getHostNameByHostId(spamNotificationInfo.getHostId());
        element.setAttribute(ATTRIBUTE_HOST_NAME, hostName);
        element.addContent(getUrlElement(spamNotificationInfo));
        return element;
    }

    @Required
    public void setSpamNotificationService(SpamNotificationService spamNotificationService) {
        this.spamNotificationService = spamNotificationService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }

//    @Required
//    public void setSpamStrategy(ByHostIdStrategy<SpamNotificationInfo> spamStrategy) {
//        this.spamStrategy = spamStrategy;
//    }
}
