package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.VerificationNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.VerificationNotificationService;
import ru.yandex.wmtools.common.data.wrappers.BlackBoxUserInfoWrapper;
import ru.yandex.wmtools.common.data.wrappers.DateWrapper;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

/**
 * @author avhaliullin
 */
public class VerificationProvider extends AbstractHostInfoProvider {

    private static final String TAG_USER = "user";
    private static final String TAG_VERIFICATION_TYPE = "ver-type";
    private static final String TAG_VERIFICATION_DATE = "ver-date";
    private static final String TAG_ROOT = "verified";

    private VerificationNotificationService verificationNotificationService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel) throws InternalException {
        VerificationNotificationInfo info = verificationNotificationService.getNotificationInfo(notification.getIssueId());
        if (info == null) {
            throw new InternalException(InternalProblem.INTERNAL_PROBLEM,
                    "verificationNotificationInfo is null: user not found in passport or host not found in db");
        }
        List<Element> elements = new ArrayList<Element>();
        Element root = new Element(TAG_ROOT);
        elements.add(root);

        root.addContent(getHostElement(info.getHostId()));
        StringBuilder user = new StringBuilder();
        new BlackBoxUserInfoWrapper(info.getUserInfo()).toXml(user);
        try {
            root.addContent(xmlToElement(user.toString(), TAG_USER));
        } catch (JDOMException e) {
            throw new InternalException(InternalProblem.INTERNAL_PROBLEM, "Cant parse AuthorWrapper's result: " + user.toString(), e);
        }

        StringBuilder date = new StringBuilder();
        new DateWrapper(info.getVerificationDate()).toXml(date);
        try {
            root.addContent(xmlToElement(date.toString(), TAG_VERIFICATION_DATE));
        } catch (JDOMException e) {
            throw new InternalException(InternalProblem.INTERNAL_PROBLEM, "Cant parse DateWrapper's result: " + date.toString(), e);
        }

        Element element = new Element(TAG_VERIFICATION_TYPE);
        element.setAttribute("name", info.getType().name());
        root.addContent(element);

        return elements;
    }

    @Required
    public void setVerificationNotificationService(VerificationNotificationService verificationNotificationService) {
        this.verificationNotificationService = verificationNotificationService;
    }
}
