package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.VirusEmailNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.HostInfoService;
import ru.yandex.wmconsole.service.VirusNotificationService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.error.InternalProblem;

public class VirusDomainProvider implements Provider {
    private static final Logger log = LoggerFactory.getLogger(VirusDomainProvider.class);

    private static final String TAG_HOST = "host";
    private static final String ATTRIBUTE_ID = "id";
    private static final String ATTRIBUTE_HOST_NAME = "name";
    private static final String ATTRIBUTE_DOMAIN_ID = "domain_id";
    private static final String ATTRIBUTE_DOMAIN_HOST_NAME = "domain_name";

    private VirusNotificationService virusNotificationService;
//    private ByHostIdStrategy<VirusEmailNotificationInfo> virusDomainStrategy;
    private HostInfoService hostInfoService;

//    @Override
//    public SendStrategy getSendStrategy() {
//        return virusDomainStrategy;
//    }

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel) throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            VirusEmailNotificationInfo virusNotificationInfo =
                    virusNotificationService.getVirusNotification(notification.getIssueId());
            if (virusNotificationInfo.getHostId() == null || virusNotificationInfo.getHostId() == 0) {
                log.warn("Host " + virusNotificationInfo.getName() + " has no id, cannot send virus notification");
                return null;
            }
            elements.add(getHostElement(virusNotificationInfo));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting virus message");
            throw e;
        }
        return elements;
    }

    private Element getHostElement(VirusEmailNotificationInfo virusNotificationInfo) throws InternalException {
        Element element = new Element(TAG_HOST);
        element.setAttribute(ATTRIBUTE_DOMAIN_ID, virusNotificationInfo.getHostId().toString());
        String hostName = hostInfoService.getHostNameByHostId(virusNotificationInfo.getHostId());
        element.setAttribute(ATTRIBUTE_DOMAIN_HOST_NAME, hostName);

        if (StringUtils.isEmpty(virusNotificationInfo.getName())) {
            throw new InternalException(InternalProblem.PROCESSING_ERROR, "Virus domain host not found");
        } else {
            element.setAttribute(ATTRIBUTE_HOST_NAME, virusNotificationInfo.getName());
        }

        return element;
    }

    @Required
    public void setVirusNotificationService(VirusNotificationService virusNotificationService) {
        this.virusNotificationService = virusNotificationService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }

//    @Required
//    public void setVirusDomainStrategy(ByHostIdStrategy<VirusEmailNotificationInfo> virusDomainStrategy) {
//        this.virusDomainStrategy = virusDomainStrategy;
//    }
}
