package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.VirusEmailNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.VirusNotificationService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class VirusProvider extends AbstractHostInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(VirusProvider.class);

    private VirusNotificationService virusNotificationService;

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            VirusEmailNotificationInfo virusNotificationInfo =
                    virusNotificationService.getVirusNotification(notification.getIssueId());
            if (virusNotificationInfo.getHostId() == null || virusNotificationInfo.getHostId() == 0) {
                log.warn("Host " + virusNotificationInfo.getName() + " has no id, cannot send virus notification");
                return null;
            }
            elements.add(getHostElement(virusNotificationInfo.getHostId()));
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting virus message");
            throw e;
        }
        return elements;
    }

    @Required
    public void setVirusNotificationService(VirusNotificationService virusNotificationService) {
        this.virusNotificationService = virusNotificationService;
    }
}
