package ru.yandex.wmconsole.notifier.provider;

import java.util.ArrayList;
import java.util.List;

import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.XssNotificationInfo;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmconsole.service.XssNotificationService;
import ru.yandex.wmtools.common.error.InternalException;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class XssProvider extends AbstractHostInfoProvider {
    private static final Logger log = LoggerFactory.getLogger(XssProvider.class);

    private XssNotificationService xssNotificationService;

    private static final String TAG_URL = "url";

    @Override
    public List<Element> getNotificationElements(NotificationInfo notification, NotificationChannelEnum channel)
            throws InternalException {
        List<Element> elements = new ArrayList<Element>();
        try {
            XssNotificationInfo xssNotificationInfo =
                    xssNotificationService.getXssNotification(notification.getIssueId());

            Element element = getHostElement(xssNotificationInfo.getHostId());

            element.addContent(getUrlElement(xssNotificationInfo));
            elements.add(element);
        } catch (InternalException e) {
            log.error("InternalException in " + getClass().getName() + " while getting xss message");
            throw e;
        }
        return elements;
    }

    private Element getUrlElement(XssNotificationInfo xssNotificationInfo) {
        Element element = new Element(TAG_URL);
        element.setText(xssNotificationInfo.getUrl());
        return element;
    }

    @Required
    public void setXssNotificationService(XssNotificationService xssNotificationService) {
        this.xssNotificationService = xssNotificationService;
    }
}
