/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
package ru.yandex.wmconsole.notifier.provider.strategy;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import ru.yandex.wmconsole.data.info.NotificationInfo;

public class DefaultSendStrategy implements SendStrategy {
    private static final DefaultSendStrategy INSTANCE = new DefaultSendStrategy();

    public static DefaultSendStrategy getInstance() {
        return INSTANCE;
    }

    private DefaultSendStrategy() {
    }

    @Override
    public List<NotificationInfo> getSendPortion(List<NotificationInfo> notifications) {
        Iterator<NotificationInfo> it = notifications.iterator();
        NotificationInfo notification;
        if (it.hasNext()) {
            notification = it.next();
            it.remove();
            return Collections.singletonList(notification);
        } else {
            return Collections.emptyList();
        }
    }
}
