package ru.yandex.wmconsole.notifier.sender;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.wmconsole.data.NotificationChannelEnum;
import ru.yandex.wmconsole.data.NotificationTypeEnum;
import ru.yandex.wmconsole.data.NotificationsForUser;
import ru.yandex.wmconsole.data.info.NotificationInfo;
import ru.yandex.wmtools.common.error.InternalException;

public class InternalSender extends AbstractSender {
    private static final Logger log = LoggerFactory.getLogger(InternalSender.class);

    @Override
    public boolean sendPortionToUser(NotificationsForUser notificationsForUser, Integer type) {
        // Just call providers
        List<NotificationInfo> notifications = notificationsForUser.getAllNotifications();

        for (NotificationInfo notification : notifications) {
            try {
                providers.get(NotificationTypeEnum.R.fromValueOrNull(notification.getNotificationType())).
                    getNotificationElements(notification, NotificationChannelEnum.MESSAGE);
            } catch (InternalException e) {
                log.error("InternalException in " + getClass().getName(), e);
                return false;
            }
        }
        return true;
    }
}
