package ru.yandex.wmconsole.notifier.sender;

import ru.yandex.wmconsole.data.NotificationsForUser;

/**
 * Describes methods that notification senders use to send notifications by different channels
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public interface Sender {
    /**
     * Sends one notification to one user descriubed in notification option
     * @param notificationsForUser user notifications portion
     * @param type notifications type (since all types are sent separately)
     * @return true if notifications were sent successfully, false if not
     */
    public boolean sendPortionToUser(NotificationsForUser notificationsForUser, Integer type);
}
