package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.service.AddHostDataVisitorService;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class AddHostDataVisitorTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(AddHostDataVisitorTask.class);

    private AddHostDataVisitorService addHostDataVisitorService;

    @Override
    public String runWithRELogging(ExecutionContext context) {
        log.info(getClass().getName() + " task fired");
        addHostDataVisitorService.fireCheck();
        return getClass().getName()+" task executed";
    }

    @Required
    public void setAddHostDataVisitorService(AddHostDataVisitorService addHostDataVisitorService) {
        this.addHostDataVisitorService = addHostDataVisitorService;
    }
}
