package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.verification.VerificationTypeEnum;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author baton
 */
public class CancelOldVerificationsTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(CancelOldVerificationsTask.class);

    private static final String TIME_TO_CANCEL_VERIFICATIONS = "INTERVAL 6 MONTH";

    private static final String UPDATE_CANCEL_OLD_VERIFICATIONS_QUERY =
            "UPDATE " +
                    "   tbl_users_hosts " +
                    "SET " +
                    "   state = " + VerificationStateEnum.RECHECK_WAITING.getValue() + ", " +
                    "   verified_on = NOW() " +
                    "WHERE " +
                    "   state = " + VerificationStateEnum.VERIFIED.getValue() + " AND " +
                    "   verification_type in (" +
                            VerificationTypeEnum.TXT_FILE.value() +
                            ", " + VerificationTypeEnum.META_TAG.value() +
                            ", " + VerificationTypeEnum.HTML_FILE.value() +
                            ", " + VerificationTypeEnum.PDD_AUTO.value() +
                            ", " + VerificationTypeEnum.PDD_EXTERNAL.value() +
                        ") AND " +
                    "   (" +
                    "        (verified_on < NOW() - " + TIME_TO_CANCEL_VERIFICATIONS + ") " +
                    "   OR " +
                    "        (verified_on IS NULL)" +
                    "   )";

    @Override
    public String runWithRELogging(ExecutionContext context) {
        log.debug("CancelOldVerificationsTask task fired");
        logUserDbConnections();
        String msg;
        try {
            getJdbcTemplate(WMCPartition.nullPartition()).update(UPDATE_CANCEL_OLD_VERIFICATIONS_QUERY);

            msg = "CancelOldVerificationsTask task OK";
            log.debug(msg);
        } catch (InternalException e) {
            msg = "CancelOldVerificationsTask task failed";
            log.error(msg, e);
        }
        logUserDbConnections();
        return msg;
    }
}
