package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.data.VerificationStateEnum;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author baton
 */
public class CheckHungVerificationsTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(CheckHungVerificationsTask.class);

    private static final String UPDATE_IN_PROGRESS_VERIFICATION_STATE_CHECK_CORRECTNESS_QUERY =
            "UPDATE " +
                    "   tbl_users_hosts " +
                    "SET " +
                    "   state = " + VerificationStateEnum.WAITING.getValue() + ", " +
                    "   verified_on = NOW() " +
                    "WHERE " +
                    "   state = " + VerificationStateEnum.IN_PROGRESS.getValue() + " AND " +
                    "   verified_on < subtime(NOW(), \"0:10:00\") ";

    private static final String UPDATE_RECHECK_IN_PROGRESS_VERIFICATION_STATE_CHECK_CORRECTNESS_QUERY =
            "UPDATE " +
                    "   tbl_users_hosts " +
                    "SET " +
                    "   state = " + VerificationStateEnum.RECHECK_WAITING.getValue() + ", " +
                    "   verified_on = NOW() " +
                    "WHERE " +
                    "   state = " + VerificationStateEnum.RECHECK_IN_PROGRESS.getValue() + " AND " +
                    "   verified_on < subtime(NOW(), \"0:10:00\") ";


    @Override
    public String runWithRELogging(ExecutionContext context) {
        log.debug("CheckHungVerificationsTask task fired");
        logUserDbConnections();
        String msg;
        try {
            getJdbcTemplate(WMCPartition.nullPartition()).update(
                    UPDATE_IN_PROGRESS_VERIFICATION_STATE_CHECK_CORRECTNESS_QUERY);
            getJdbcTemplate(WMCPartition.nullPartition()).update(
                    UPDATE_RECHECK_IN_PROGRESS_VERIFICATION_STATE_CHECK_CORRECTNESS_QUERY);

            msg = "CheckHungVerificationsTask task OK";
            log.debug(msg);
        } catch (InternalException e) {
            msg = "CheckHungVerificationsTask task failed";
            log.error(msg, e);
        }
        logUserDbConnections();
        return msg;
    }
}
