package ru.yandex.wmconsole.periodic;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.StringTokenizer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.HttpConnector;
import ru.yandex.wmtools.common.util.HttpResponse;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class CheckTcyTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(CheckTcyTask.class);

    // TODO: rewrite this shit
    private static final long SECONDS_IN_MINUTE = 60;
    private static final long SECONDS_IN_HOUR = SECONDS_IN_MINUTE * 60;
    private static final long SECONDS_IN_6_HOURS = SECONDS_IN_HOUR * 6;
    private static final long SECONDS_IN_DAY = SECONDS_IN_HOUR * 24;
    private static final long SECONDS_IN_YEAR = SECONDS_IN_DAY * 365;

    private static final String LAST_MODIFIED_HEADER_NAME = "Last-Modified";

    private static final String SELECT_TCY_CACHE_LAST_MODIFIED_QUERY =
            "SELECT " +
                    "    last_modified " +
                    "FROM " +
                    "    tbl_tcy_last_modified_cache ";

    private static final String INSERT_TCY_CACHE_LAST_MODIFIED_QUERY =
            "INSERT INTO " +
                    "    tbl_tcy_last_modified_cache (id, last_modified) " +
                    "VALUES " +
                    "    (0, ?) " +
                    "ON DUPLICATE KEY UPDATE " +
                    "    last_modified = ? ";

    private static final String DELETE_CLEAR_TCY_CACHES_QUERY =
            "DELETE FROM " +
                    "    tbl_tcy_cache ";

    public static final String CYCOUNTER_URL = "http://yandex.ru/cycounter?www.yandex.ru";

    public void checkTcyUpdated() throws InternalException {
        try {
            HttpResponse response = httpPostGetResponse(CYCOUNTER_URL);
            Collection<String> lastModifiedHeaders = response.getHeaders().get(LAST_MODIFIED_HEADER_NAME);

            {
                int count = lastModifiedHeaders.size();
                if (count != 1) {
                    log.error("Expected 1 '" + LAST_MODIFIED_HEADER_NAME + "' header, but found: " + count);
                    return;
                }
            }

            String realTcyLastUpdated = getNumbersFromString(lastModifiedHeaders.iterator().next());
            String cachedTcyLastUpdated = getJdbcTemplate(WMCPartition.nullPartition()).safeQueryForString(
                    SELECT_TCY_CACHE_LAST_MODIFIED_QUERY);

            if ((cachedTcyLastUpdated == null) || (Math.abs(getTimeInSecondsForCompare(cachedTcyLastUpdated) - getTimeInSecondsForCompare(realTcyLastUpdated)) > SECONDS_IN_6_HOURS)) {
                log.debug("TCY was updated! Clearing caches. Cached value: '" + cachedTcyLastUpdated + "', new value: '" + realTcyLastUpdated + "'");
                getJdbcTemplate(WMCPartition.nullPartition()).update(INSERT_TCY_CACHE_LAST_MODIFIED_QUERY, realTcyLastUpdated, realTcyLastUpdated);

                int dbCount = WMCPartition.getHostDbCount(getDatabaseCount());
                for (int i = 0; i < dbCount; i++) {
                    logConnections(i);
                    getJdbcTemplate(new WMCPartition(i)).update(DELETE_CLEAR_TCY_CACHES_QUERY);
                    logConnections(i);
                }
            }
        } catch (IOException e) {
            log.error("Error occured while trying to load page with TCY", e);
        }
    }

    private long getTimeInSecondsForCompare(String time) {
        long res = 0;

        // tokens: day year hour min sec
        StringTokenizer tok = new StringTokenizer(time);
        res += Integer.parseInt(tok.nextToken()) * SECONDS_IN_DAY; // day
        res += Integer.parseInt(tok.nextToken()) * SECONDS_IN_YEAR; // year
        res += Integer.parseInt(tok.nextToken()) * SECONDS_IN_HOUR; // hour
        res += Integer.parseInt(tok.nextToken()) * SECONDS_IN_MINUTE; // min
        res += Integer.parseInt(tok.nextToken()); // sec

        return res;
    }

    private String getNumbersFromString(String value) {
        StringBuilder res = new StringBuilder();

        StringTokenizer tok = new StringTokenizer(value, " :");
        while (tok.hasMoreTokens()) {
            boolean ok = true;
            String next = tok.nextToken();

            try {
                Integer.parseInt(next);
            } catch (NumberFormatException e) {
                ok = false;
            }

            if (ok) {
                res.append(next).append(" ");
            }
        }

        return res.toString();
    }

    @Override
    public String runWithRELogging(ExecutionContext context) {
        String msg = getClass().getName()+" task executed.";
        logUserDbConnections();
        try {
            checkTcyUpdated();
        } catch (InternalException e) {
            msg ="InternalException while checking tcy update in periodic task";
            log.error(msg, e);
        }
        logUserDbConnections();
        return msg;
    }

    private static HttpResponse httpPostGetResponse(String urlAddress) throws IOException {
        String BOUNDARY = "256jkkldsf452Sasd3HSDsa";
        String stringEntity = "--" + BOUNDARY + "\r\n";

        return new HttpConnector.RequestBuilder(new URL(urlAddress))
                .method(HttpConnector.HttpMethod.POST)
                .header("Content-Type", "multipart/form-data; boundary=" + BOUNDARY)
                .entity(stringEntity, "UTF-8")
                .allowRedirect(true)
                .okStatusRequired(false)
                .execute();
    }
}
