package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.service.NotificationSenderService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author ailyin
 */
public class DeleteOldNotificationsTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(DeleteOldNotificationsTask.class);

    private NotificationSenderService notificationSenderService;

    @Override
    public String runWithRELogging(ExecutionContext context) {
        log.debug("DeleteOldNotificationsTask task fired");
        logUserDbConnections();
        String msg;
        try {
            notificationSenderService.cleanup();
            msg = "DeleteOldNotificationsTask task OK";
            log.debug(msg);
        } catch (InternalException e) {
            msg = "DeleteOldNotificationsTask task failed";
            log.error(msg, e);
        }
        logUserDbConnections();
        return msg;
    }

    @Required
    public void setNotificationSenderService(NotificationSenderService notificationSenderService) {
        this.notificationSenderService = notificationSenderService;
    }
}
