package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmconsole.service.dao.TblHostUpdatesDao;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * User: azakharov
 * Date: 09.01.14
 * Time: 13:19
 */
public class DeleteOldOfflineLinksTask extends AbstractTaskExecutor {

    private static final Logger log = LoggerFactory.getLogger(DeleteOldOfflineLinksTask.class);

    private TblHostUpdatesDao tblHostUpdatesDao;

    @Override
    public String runWithRELogging(ExecutionContext context) throws InternalException {
        for (int i = 0; i < WMCPartition.getHostDbCount(getDatabaseCount()); i++) {
            log.info("updating offline links in host db {}", i);
            tblHostUpdatesDao.deleteOldOfflineLinks(i);
        }
        return DeleteOldOfflineLinksTask.class.getSimpleName() + " finished";
    }

    @Required
    public void setTblHostUpdatesDao(TblHostUpdatesDao tblHostUpdatesDao) {
        this.tblHostUpdatesDao = tblHostUpdatesDao;
    }
}
