package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.service.HostVisitorService;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * @author Andrey Mima (amima@yandex-team.ru)
 */
public class HostVisitorTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(HostVisitorTask.class);

    private HostVisitorService hostVisitorService;

    @Override
    public String runWithRELogging(ExecutionContext context) {
        log.info(getClass().getName() + " task fired");
        hostVisitorService.fireCheck();
        return getClass().getName() + " task executed";
    }

    @Required
    public void setHostVisitorService(HostVisitorService hostVisitorService) {
        this.hostVisitorService = hostVisitorService;
    }
}
