package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.service.MainMirrorProcessingService;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

/**
 * User: azakharov
 * Date: 14.03.14
 * Time: 15:46
 */
public class MainMirrorChangeTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(MainMirrorChangeTask.class);

    private MainMirrorProcessingService mainMirrorProcessingService;

    @Override
    public String runWithRELogging(ExecutionContext context) throws InternalException {
        log.info("Started MainMirrorChangeTask");
        mainMirrorProcessingService.changeMainMirrors();
        log.info("Finished MainMirrorChangeTask");
        return "Finished successful";
    }

    @Required
    public void setMainMirrorProcessingService(MainMirrorProcessingService mainMirrorProcessingService) {
        this.mainMirrorProcessingService = mainMirrorProcessingService;
    }
}
