package ru.yandex.wmconsole.periodic;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

import ru.yandex.common.scheduler.ExecutionContext;
import ru.yandex.wmconsole.notifier.sender.NotificationSender;
import ru.yandex.wmtools.common.util.scheduler.timetable.AbstractTaskExecutor;

public class NotifierTask extends AbstractTaskExecutor {
    private static final Logger log = LoggerFactory.getLogger(NotifierTask.class);

    private NotificationSender notificationSender;

    @Override
    public String runWithRELogging(ExecutionContext context) {
        try {
            log.debug("Notifier triggered");
            logUserDbConnections();
            notificationSender.sendAll();
        } catch (Exception e) {
            log.error("Exception in " + getClass().getName(), e);
        }
        logUserDbConnections();
        return getClass().getName() + " task executed";
    }

    @Required
    public void setNotificationSender(NotificationSender notificationSender) {
        this.notificationSender = notificationSender;
    }
}
