package ru.yandex.webmaster.support.host.dao;

import java.net.IDN;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.springframework.jdbc.core.simple.ParameterizedRowMapper;

import ru.yandex.misc.db.q.ConditionUtils;
import ru.yandex.misc.db.q.SqlCondition;
import ru.yandex.misc.db.q.SqlLimits;
import ru.yandex.webmaster.common.util.HostnamePart;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.data.partition.WMCPartition;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.AbstractDbService;

/**
 * @author aherman
 */
public class TblHostsMainSupportDao extends AbstractDbService {
    public List<BriefHostInfo> findHosts(HostnamePart hostnamePart, int size) throws InternalException {
        SqlCondition c = hostnamePartC(hostnamePart);
        String q = "SELECT * FROM tbl_hosts WHERE " + c.sql() + " " + SqlLimits.first(size).toMysqlLimits();
        return getJdbcTemplate(WMCPartition.nullPartition()).query(q, hostInfoMapper(), c.args().toArray());
    }

    private static ParameterizedRowMapper<BriefHostInfo> hostInfoMapper() {
        return new ParameterizedRowMapper<BriefHostInfo>() {
            @Override
            public BriefHostInfo mapRow(ResultSet resultSet, int i) throws SQLException {
                String name = resultSet.getString("name");
                long hostId = resultSet.getLong("host_id");
                long mirrorId = resultSet.getLong("mirror_id");
                return new BriefHostInfo(hostId, name, mirrorId);
            }
        };
    }

    private static SqlCondition hostnamePartC(HostnamePart hostnamePart) {
        ConditionUtils.Column column = SqlCondition.column("name");


        String likeString;
        if (hostnamePart.isIDN()) {
            likeString = IDN.toASCII(hostnamePart.getHostnamePart());
        } else {
            likeString = hostnamePart.getHostnamePart();
        }
        if (hostnamePart.getProtocol() == HostnamePart.Protocol.HTTPS) {
            likeString = "https://" + likeString;
        }

        SqlCondition result;
        if (hostnamePart.isPrefix() || hostnamePart.isIDN()) {
            result = column.like(likeString + "%");
        } else {
            result = column.like("%" + likeString + "%");
        }

        return result;
    }
}
