package ru.yandex.webmaster.support.http.servantlet;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.common.framework.user.UserInfo;
import ru.yandex.webmaster.common.WebmasterException;
import ru.yandex.webmaster.common.WebmasterExceptionType;
import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.http.RequestFilter;
import ru.yandex.webmaster.common.seolinks.dao.TblSeoLinksHistoryDao;
import ru.yandex.webmaster.common.seolinks.info.SeoLinksHistoryRecord;
import ru.yandex.webmaster.support.http.servantlet.filter.SupportUserFilter;
import ru.yandex.wmtools.common.error.UserException;
import ru.yandex.wmtools.common.error.UserProblem;
import ru.yandex.wmtools.common.service.UserService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author avhaliullin
 */
public class SeoLinksHistoryAction extends Action<SeoLinksHistoryRequest, SeoLinksHistoryResponse> {
    private TblSeoLinksHistoryDao tblSeoLinksHistoryDao;
    private UserService userService;

    @Override
    public SeoLinksHistoryResponse process(SeoLinksHistoryRequest request) throws Exception {
        String forLogin = request.getLogin();
        String forHostName = request.getHostname();
        List<SeoLinksHistoryRecord> records;
        if (forLogin != null) {
            Long forUserId = userService.getUidByLogin(forLogin);
            if (forUserId == null) {
                throw new WebmasterException(WebmasterExceptionType.USER__NO_SUCH_USER_IN_PASSPORT, "User " + forLogin + " not found in service");
            }

            if (forHostName != null) {
                records = tblSeoLinksHistoryDao.listHistoryRecordsForHostAndUser(forHostName, forUserId);
            } else {
                records = tblSeoLinksHistoryDao.listHistoryRecordsForUser(forUserId);
            }
        } else if (forHostName != null) {
            records = tblSeoLinksHistoryDao.listHistoryRecordsForHost(forHostName);
        } else {
            throw new WebmasterException(WebmasterExceptionType.REQUEST__REQUIRED_PARAMETER_MISSING, "At least one of login or hostname should be specified");
        }
        List<SeoLinksHistoryResponse.HistoryRecord> recordsView = new ArrayList<>();
        Map<Long, String> uid2Login = new HashMap<>();
        for (SeoLinksHistoryRecord record : records) {
            String login = null;
            if (uid2Login.containsKey(record.getUserId())) {
                login = uid2Login.get(record.getUserId());
            } else {
                UserInfo userInfo = userService.getUserInfo(record.getUserId());
                if (userInfo != null) {
                    login = userInfo.getLogin();
                    uid2Login.put(record.getUserId(), login);
                }
            }
            recordsView.add(new SeoLinksHistoryResponse.HistoryRecord(record.getCreatedAt(), record.getHostName(), login, !record.isUseSeoLinks()));
        }
        return new SeoLinksHistoryResponse(recordsView);
    }

    @Override
    public List<Class<? extends RequestFilter>> getRequestFilters() {
        List<Class<? extends RequestFilter>> result = super.getRequestFilters();
        result.add(SupportUserFilter.class);
        return result;
    }

    @Required
    public void setTblSeoLinksHistoryDao(TblSeoLinksHistoryDao tblSeoLinksHistoryDao) {
        this.tblSeoLinksHistoryDao = tblSeoLinksHistoryDao;
    }

    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }
}
