package ru.yandex.webmaster.support.http.servantlet;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.webmaster.common.http.request.HostnameAware;
import ru.yandex.webmaster.common.http.request.UserIdAware;

/**
 * @author avhaliullin
 */
public class SeoLinksHistoryRequest implements ActionRequest, UserIdAware, HostnameAware {
    private String hostname;
    private String login;
    private long userId;

    public String getHostname() {
        return hostname;
    }

    @Override
    @RequestQueryProperty(required = false)
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public long getUserId() {
        return userId;
    }

    public String getLogin() {
        return login;
    }

    @Required
    @RequestQueryProperty(required = false)
    public void setLogin(String login) {
        this.login = login;
    }
}
