package ru.yandex.webmaster.support.http.servantlet;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import ru.yandex.webmaster.common.http.ActionResponse;

import java.util.Date;
import java.util.List;

/**
 * @author avhaliullin
 */
public class SeoLinksHistoryResponse implements ActionResponse {

    private final List<HistoryRecord> historyRecords;

    public SeoLinksHistoryResponse(List<HistoryRecord> historyRecords) {
        this.historyRecords = historyRecords;
    }

    @JacksonXmlProperty(localName = "record")
    @JacksonXmlElementWrapper(localName = "records")
    public List<HistoryRecord> getHistoryRecords() {
        return historyRecords;
    }

    public static class HistoryRecord {
        private final Date date;
        private final String hostName;
        private final String userLogin;
        private final boolean ignoreSeoLinks;

        public HistoryRecord(Date date, String hostName, String userLogin, boolean ignoreSeoLinks) {
            this.date = date;
            this.hostName = hostName;
            this.userLogin = userLogin;
            this.ignoreSeoLinks = ignoreSeoLinks;
        }

        public Date getDate() {
            return date;
        }

        public String getUserLogin() {
            return userLogin;
        }

        public boolean isIgnoreSeoLinks() {
            return ignoreSeoLinks;
        }

        public String getHostName() {
            return hostName;
        }
    }
}
