package ru.yandex.webmaster.support.http.servantlet;

import java.net.IDN;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.http.Action;
import ru.yandex.webmaster.common.util.HostnamePart;
import ru.yandex.webmaster.support.host.SupportHostService;
import ru.yandex.webmaster.common.util.HostnamePartUtils;
import ru.yandex.wmconsole.data.info.BriefHostInfo;
import ru.yandex.wmconsole.service.HostInfoService;

/**
 * @author aherman
 */
public class SuggestHostnameAction extends Action<SuggestHostnameRequest, SuggestHostnameResponse> {
    private SupportHostService supportHostService;
    private HostInfoService hostInfoService;

    @Override
    public SuggestHostnameResponse process(SuggestHostnameRequest request) throws Exception {
        HostnamePart hostnamePart = HostnamePartUtils.cleanHostnamePart(request.getQuery());
        if (hostnamePart == null) {
            return new SuggestHostnameResponse(Collections.<SuggestHostnameResponse.Suggestion>emptyList());
        }

        List<BriefHostInfo> hostsByNamePart = supportHostService.findHostsByNamePart(hostnamePart, 10);
        List<SuggestHostnameResponse.Suggestion> result = new ArrayList<>(hostsByNamePart.size());
        for (BriefHostInfo briefHostInfo : hostsByNamePart) {
            BriefHostInfo mirrorHostInfo = null;

            if (briefHostInfo.getMainMirrorId() != null) {
                mirrorHostInfo = hostInfoService
                        .getBriefHostInfoByIdOrName(briefHostInfo.getMainMirrorId().toString());
            }

            result.add(new SuggestHostnameResponse.Suggestion(
                    briefHostInfo.getId(),
                    IDN.toUnicode(briefHostInfo.getName()),
                    mirrorHostInfo != null ? mirrorHostInfo.getId() : 0,
                    mirrorHostInfo != null ? IDN.toUnicode(mirrorHostInfo.getName()) : null
            ));
        }

        return new SuggestHostnameResponse(result);
    }

    @Required
    public void setSupportHostService(SupportHostService supportHostService) {
        this.supportHostService = supportHostService;
    }

    @Required
    public void setHostInfoService(HostInfoService hostInfoService) {
        this.hostInfoService = hostInfoService;
    }
}
