package ru.yandex.webmaster.support.http.servantlet;

import java.util.List;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import ru.yandex.webmaster.common.http.ActionResponse;

/**
 * @author aherman
 */
public class SuggestHostnameResponse implements ActionResponse {
    private final List<Suggestion> suggestions;

    public SuggestHostnameResponse(
            List<Suggestion> suggestions)
    {
        this.suggestions = suggestions;
    }

    @JacksonXmlElementWrapper(localName = "suggestions")
    @JacksonXmlProperty(localName = "suggestion")
    public List<Suggestion> getSuggestions() {
        return suggestions;
    }

    public static class Suggestion {
        private final String hostname;
        private final long hostId;

        private final String mirrorHostname;
        private final long mirrorHostId;

        public Suggestion(long hostId, String hostname, long mirrorHostId, String mirrorHostname) {
            this.hostname = hostname;
            this.hostId = hostId;
            this.mirrorHostId = mirrorHostId;
            this.mirrorHostname = mirrorHostname;
        }

        public String getHostname() {
            return hostname;
        }

        public long getHostId() {
            return hostId;
        }

        public String getMirrorHostname() {
            return mirrorHostname;
        }

        public long getMirrorHostId() {
            return mirrorHostId;
        }
    }
}
