package ru.yandex.webmaster.support.http.servantlet.filter;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.webmaster.common.WebmasterActionException;
import ru.yandex.webmaster.common.WebmasterException;
import ru.yandex.webmaster.common.WebmasterExceptionType;
import ru.yandex.webmaster.common.http.RequestFilter;
import ru.yandex.webmaster.common.http.request.UserIdAware;
import ru.yandex.wmtools.common.error.InternalException;
import ru.yandex.wmtools.common.service.ISupportService;

/**
 * @author aherman
 */
public class SupportUserFilter implements RequestFilter {
    private ISupportService supportService;

    @Override
    public void beforeRequest(String action, Object request) {
        if (!(request instanceof UserIdAware)) {
            throw new WebmasterActionException(WebmasterExceptionType.INTERNAL__UNKNOWN, "Action is not UserIdAware: " + action);
        }

        long userId = ((UserIdAware) request).getUserId();
        try {
            if (!supportService.isSupportUser(userId)) {
                throw new WebmasterActionException(WebmasterExceptionType.SUPPORT__NOT_SUPPORT_USER, "User is not support");
            }
        } catch (InternalException e) {
            throw new WebmasterActionException(WebmasterExceptionType.INTERNAL__SQL, "Unable to check support user", e);
        }
    }

    @Required
    public void setSupportService(ISupportService supportService) {
        this.supportService = supportService;
    }
}
