package ru.yandex.webmaster.support.http.servantlet.host;

import ru.yandex.webmaster.common.host.HostEventType;
import ru.yandex.webmaster.common.http.ActionRequest;
import ru.yandex.webmaster.common.http.RequestQueryProperty;
import ru.yandex.webmaster.common.http.request.HostnameAware;
import ru.yandex.webmaster.common.http.request.PagerAware;
import ru.yandex.webmaster.common.http.request.UserIdAware;

/**
 * @author aherman
 */
public class GetHostEventsRequest implements ActionRequest, UserIdAware, PagerAware, HostnameAware {
    private long userId;
    private HostEventType hostEventType;
    private Long eventForUserId;
    private int page = 0;
    private int pageSize = 25;
    private String hostname;

    @Override
    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public long getUserId() {
        return userId;
    }

    public HostEventType getHostEventType() {
        return hostEventType;
    }

    @RequestQueryProperty
    public void setHostEventType(HostEventType hostEventType) {
        this.hostEventType = hostEventType;
    }

    @RequestQueryProperty
    public void setEventForUserId(Long eventForUserId) {
        this.eventForUserId = eventForUserId;
    }

    public Long getEventForUserId() {
        return eventForUserId;
    }

    @Override
    public void setP(int page) {
        this.page = page;
    }

    public int getPage() {
        return page;
    }

    @Override
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }


    public String getHostname() {
        return hostname;
    }

    @Override
    @RequestQueryProperty(required = true)
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}
