package ru.yandex.webmaster.support.http.servantlet.host;

import java.util.List;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;

import ru.yandex.webmaster.common.host.HostEvent;
import ru.yandex.webmaster.common.http.ActionResponse;
import ru.yandex.webmaster.common.http.response.HostResponse;
import ru.yandex.webmaster.common.http.response.OldPager;

/**
 * @author aherman
 */
public class GetHostEventsResponse implements ActionResponse {
    private final int eventsCount;
    private final List<HostEvent> events;
    private final HostResponse host;
    private final OldPager pager;

    public GetHostEventsResponse(int eventsCount, HostResponse host, List<HostEvent> events, OldPager pager) {
        this.eventsCount = eventsCount;
        this.host = host;
        this.events = events;
        this.pager = pager;
    }

    public int getEventsCount() {
        return eventsCount;
    }

    public HostResponse getHost() {
        return host;
    }

    @JacksonXmlProperty(localName = "event")
    @JacksonXmlElementWrapper(localName = "events")
    public List<HostEvent> getEvents() {
        return events;
    }

    public OldPager getPager() {
        return pager;
    }
}
